clear all
set more off

cd "..\Processed Data"

use AverageWagesMonthly, clear

egen ID=group(SubnationalClean)

gen lnY=log(value)

gen YYYY=substr(date,1,4)
destring YYYY, force replace

gen MM=substr(date,6,2)
destring MM, force replace



gen time=YYYY+(MM-1)/12
egen TT=group(YYYY MM)
tsset ID TT

sum ID
local rmax=r(max)

gen lnY_SA=.
gen lnY_MA=.

quiet forvalues i=1(1)`rmax' {
	noisily di "`i' of `rmax'"
	capture drop lnYx
	tssmooth ma lnYx=lnY if ID==`i', window(20 1 20)
	
	capture drop dlnYx
	gen dlnYx=lnY-lnYx
	reg dlnYx i.MM lnYx if ID==`i'
	capture drop xb
	predict xb, xb
	replace lnY_SA=lnY-xb if ID==`i'
	
	capture drop lnYx
	tssmooth ma lnYx=lnY if ID==`i', window(11 1 0)	
	replace lnY_MA=lnYx if ID==`i'

}




*** seasonal adjustment



collapse (sd) lnY lnY_SA lnY_MA ///
		(p90) lnY_p90 = lnY lnY_SA_p90 = lnY_SA lnY_MA_p90 = lnY_MA ///
		(p50) lnY_p50 = lnY lnY_SA_p50 = lnY_SA lnY_MA_p50 = lnY_MA ///
		(p10) lnY_p10 = lnY lnY_SA_p10 = lnY_SA lnY_MA_p10 = lnY_MA ///
		, by(YYYY MM)

gen time=YYYY+(MM-1)/12
egen TT=group(YYYY MM)
tsset TT


foreach var in lnY lnY_SA lnY_MA {
	replace `var'_p90=. if `var'_p90==0
	replace `var'_p50=. if `var'_p50==0
	replace `var'_p10=. if `var'_p10==0
	
	
	gen `var'_9010=`var'_p90- `var'_p10
	gen `var'_9050=`var'_p90- `var'_p50
	gen `var'_5010=`var'_p50- `var'_p10
	

	
}


replace lnY_MA_9010=. if lnY_MA_9010==0
replace lnY_MA_9050=. if lnY_MA_9050==0
replace lnY_MA_5010=. if lnY_MA_5010==0


twoway (line lnY_MA_9010 time if time>=2000 & time<=2025) (line lnY_MA_9050 time if time>=2000 & time<=2025) (line lnY_MA_5010 time if time>=2000 & time<=2025) ///
	, legend(label(1 "90-10") label(2 "90-50") label(3 "50-10")) ///
	ytitle("log difference between percentiles of" "average nominal wages") ///
	xline(2014.25, lpattern(dash) lcolor(black))  xline(2022.1, lpattern(dash) lcolor(black)) xlabel(2000(2)2024, labsize(small)) xtitle("")
	
twoway line lnY_MA	time if time>=2000 & time<=2025, ytitle("std(log(average nominal wages))") xline(2014.25, lpattern(dash) lcolor(black))  xline(2022.1, lpattern(dash) lcolor(black)) xlabel(2000(1)2025, labsize(small) angle(30)) xtitle("")

